//****************************************************************************************
// Name:		proc.cpp
// Platform:	SQL Server 2000 SP3a or higher, Windows NT, 2000 or XP
// Author:		Copyright (c) 2006 by Michael Coles, MCDBA
//
// Description:	This code implements the xp_regex_search extended stored procedure.  This 
//				code is built upon the Boost Regex++ library.
//
// LEGAL STUFF:
// ------------
// Copyright (C) 2005 - 2006 by Michael Coles, MCDBA
//
// Some included code included is released under the redistribution agreements as 
// specified by the authors of the respective code.  Copyright holders of this included 
// code maintain all copyright and other rights to their original or derivative works.
//
// All rights reserved.                          
//
// REDISTRIBUTION OF THIS CODE:
// ----------------------------
// All code included in this package is either the original work of the copyright holder,
// or derivative work based on other copyright holders' works.  All derivative works 
// include information as required by the copright holders' redistribution agreements.
// These redistribution agreements, where possible, are included in the text of the source
// code distributed with this code.
//
// Redistribution and use in source and binary forms, with or without modification, are 
// permitted provided that the following conditions are met:
//
//   1. Redistributions of source code must retain the above copyright notice, this list 
//      of conditions and the following disclaimer.
//
//   2. Redistributions in binary form must reproduce the above copyright notice, this 
//      list of conditions and the following disclaimer in the documentation and/or other 
//      materials provided with the distribution.
//
//   3. The names of its contributors may not be used to endorse or promote products 
//      derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY 
// WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//****************************************************************************************
//
// Pertaining to the Boost Regex++ library:
//
// The Boost Regex++ Library is Copyright (c) 1998-2000 by Dr John Maddock
// 
// Use, modification and distribution are subject to the Boost Software License, Version 
// 1.0. (See accompanying file LICENSE_1_0.txt or copy at 
// http://www.boost.org/LICENSE_1_0.txt)

#define BOOST_REGEX_STATIC_LINK
#define BOOST_REGEX_NO_LIB 
#include <constants.h>
#include <dblib.h>
#include <params.h>
#include <boost/regex.hpp>
#include <stdafx.h>

using namespace boost;

#ifdef __cplusplus
extern "C" {
#endif

RETCODE __declspec(dllexport) xp_regex_replace(SRV_PROC *srvproc);

#ifdef __cplusplus
}
#endif

RETCODE __declspec(dllexport) xp_regex_replace(SRV_PROC *srvproc)
{	
	RETCODE rc = XP_NOERROR;
	int rowcount = 0;
	params *P1 = new params();  // regex
	params *P2 = new params();  // input string
	params *P3 = new params();  // replacement string
	params *P4 = new params();  // flags
	params *P5 = new params();  // output
	std::string output;
	BYTE *x = NULL;
	try
	{
		int numparams = params::getparamcount(srvproc);
		if (numparams != 5) {
			Dblib::printerror(srvproc, USAGE_REGEX_SEARCH);
			rc = XP_ERROR;
		}
		int case_i = boost::regbase::normal;	
		bool show_groups = false;
		if (rc == XP_NOERROR) {
			params::getparam(srvproc, 1, P1);
			params::getparam(srvproc, 2, P2);
			params::getparam(srvproc, 3, P3);
			params::getparam(srvproc, 4, P4);
			params::getparam(srvproc, 5, P5);
			if (P1->isoutput || P2->isoutput || P3->isoutput || P4->isoutput || !P5->isoutput) {
				Dblib::printerror(srvproc, USAGE_REGEX_REPLACE);
				rc = XP_ERROR;
			}
		}
		if (rc == XP_NOERROR) {
			std::string options = strupr((char *)P4->cdata);
			int w = (int)options.find("I+");
			if (w > -1) {
				case_i |= boost::regbase::icase;
			}
			boost::regex expression((const char *)P1->cdata, case_i);
			std::string input = (const char *)P2->cdata;
			std::string replacement = (const char *)P3->cdata;
			boost::match_flag_type flags = boost::match_default; 
			output = boost::regex_replace(input, expression, replacement, flags);
		}
	} catch(boost::regex_error re) {
		Dblib::printerror(srvproc, ERR_REGEX_EXCEPTION);
		rc = XP_ERROR;
	}
	if (rc != XP_ERROR) {
		srv_paramsetoutput(srvproc, 5, (BYTE *)output.c_str(), (ULONG)output.length(), FALSE);
	} else {
		srv_paramsetoutput(srvproc, 5, (BYTE *)"", 0, TRUE);
	}
	srv_senddone(srvproc, SRV_DONE_MORE, (DBUSMALLINT)0, (DBINT)0);
	if (x != NULL)
		delete [] x;
	x = NULL;
	if (P1 != NULL)
		delete P1;
	P1 = NULL;
	if (P2 != NULL)
		delete P2;
	P2 = NULL;
	if (P3 != NULL)
		delete P3;
	P3 = NULL;
	if (P4 != NULL)
		delete P4;
	P4 = NULL;
	if (P5 != NULL)
		delete P5;
	P5 = NULL;
	return rc;
}

